/*------------------------------------------------------------------------------*
 * File Name: ComboBox.h	 													*
 * Creation: SDB 11/19/2003														*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

class Combox : public Dialog
{
public:
	Combox() : Dialog(IDD_CB_COMBOBOX, "ComboBox")
	{
	}
	int DoModal(HWND hParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}
protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_CBN_SELCHANGE(IDC_CB_COMBO1, OnSelChange)
		ON_OK(OnOK)
		ON_CANCEL(OnCancel)
	EVENTS_END
///----------------------------------------------
	
	BOOL OnInitDialog()
	{
		PageBase page;
		string strName;
		m_cbxWindows = GetItem(IDC_CB_COMBO1);
		m_btnActiveCheck = GetItem(IDC_CB_ACTIVATECHECK);
		foreach(page in Project.Pages)
		{
			strName = page.GetName();
			m_cbxWindows.AddString(strName);
		}
		Page pg = Project.Pages();
		string strWindow = pg.GetName();
		m_cbxWindows.Text = strWindow;
		return TRUE;
	}

	BOOL OnOK()
	{
		if(m_btnActiveCheck.Check)
		{
			string strText, strWindow;
			m_cbxWindows.GetLBText(m_cbxWindows.GetCurSel() ,strWindow);
			strText.Format("win -a %s", strWindow);
			LT_execute(strText);		
		}
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		return TRUE;
	}

	BOOL OnSelChange(Control oCntrl)
	{
		string strText;
		m_cbxWindows.GetLBText(m_cbxWindows.GetCurSel() ,strText);
		printf("\nThe combo box selection is %s", strText);
		return TRUE;
	}
		
private:
	ComboBox m_cbxWindows; // ListBox control
	Button m_btnActiveCheck; // Checkbox
};
